package com.android.print.demo;

import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.widget.Toast;

import com.mht.print.sdk.PrinterConstants;
import com.mht.print.sdk.PrinterInstance;
import com.mht.print.sdk.util.Utils;

public class WifiOperation implements IPrinterOpertion {
    private Context mContext;
    private Handler mHandler;
    private PrinterInstance mPrinter;
    private WifiManager wifiManager;
    private int errorNumber;

    public WifiOperation(Context context, Handler handler) {
        mContext = context;
        mHandler = handler;
        wifiManager = (WifiManager) mContext.getSystemService(Context.WIFI_SERVICE);
    }

    @Override
    public void close() {
        if (mPrinter != null) {
            mPrinter.closeConnection();
            mPrinter = null;
        }
    }

    @Override
    public PrinterInstance getPrinter() {
        return mPrinter;
    }

    @Override
    public void open(Intent data) {
        String ipAddress = data.getStringExtra("ip_address");
        mPrinter = new PrinterInstance(ipAddress, 9100, mHandler);
        mPrinter.openConnection();
        /*try {
            int retryCount = 0;
            while (retryCount < 10) {
                if (mPrinter.isConnected()) {
                    break;
                }
                Thread.sleep(1000);
                retryCount += 1;
            }
            byte[] bytes = Utils.hex2byte("1B401B401B401B61001D21111B45011B2D005BD0C2BDA85DA1A1C1F7CBAEBAC53A303037310A1B401B61021D21001B45001B2D0031383A30370A1B61001D21001B45001B2D000A1B401B61001D21111B45001B2D00BABAB1A42020202020202020202020310A1B401B61001D21111B45001B2D00BFC9C0D62020202020202020202020310A1B401B61001D21111B45001B2D00C4CCB2E82020202020202020202020310A1B64041B6402");
            mPrinter.sendByteData(bytes);
            int printerStatus = mPrinter.getPrinterStatus();
            String stateName = "查询失败";
            switch (printerStatus) {
                case PrinterConstants.State.READY:
                    stateName = "有纸";
                    break;
                case PrinterConstants.State.OUT_OF_PAPER:
                    stateName = "缺纸";
                    break;
                case PrinterConstants.State.OPEN_THE_LID:
                    stateName = "开盖";
                    break;
                default:
                    break;
            }
            String finalStateName = stateName;
            mHandler.post(() -> Toast.makeText(mContext, "打印机状态：" + finalStateName, Toast.LENGTH_SHORT).show());
            mPrinter.closeConnection();
        } catch (Exception e) {
            e.printStackTrace();
        }*/
    }

    @Override
    public void chooseDevice() {
        if (!wifiManager.isWifiEnabled()) {
            wifiManager.setWifiEnabled(true);
        }
        Intent intent = new Intent();
        intent.setClass(mContext, IpAddressEdit.class);
        ((Activity) mContext).startActivityForResult(intent, MainActivity.CONNECT_DEVICE);
    }
}
